#!/bin/sh

MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_OK=0
MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_ERROR=1
MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_CODE=${MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_ERROR}

MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_ROLLING=0
MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_MSG=""

master_page_ms_dhcp_or_static() {
	debug_print "${0}" "${LINENO}" 'in function "master_page_ms_dhcp_or_static"'
	
    # assign default value
    [ -z "${RT_MS_IP}" ]      && RT_MS_IP="${conf_ms_ip}"
    [ -z "${RT_MS_NETMASK}" ] && RT_MS_NETMASK="${conf_ms_netmask}"
    [ -z "${RT_MS_DNS}" ]     && RT_MS_DNS="${conf_ms_dns}"
    [ -z "${RT_MS_DNS2}" ]     && RT_MS_DNS2="${conf_ms_dns2}"
    [ -z "${RT_MS_GATEWAY}" ] && RT_MS_GATEWAY="${conf_ms_gateway}"
    
	tp_dhcp_or_static \
		"${MASTER_PAGE_MS_DHCP_OR_STATIC_TITLE}" \
		"${MASTER_PAGE_MS_DHCP_OR_STATIC_TEXT}" \
		"${MASTER_PAGE_MS_DHCP_OR_STATIC_LABEL_OK}" \
		"${MASTER_PAGE_MS_DHCP_OR_STATIC_LABEL_CANCEL}"

	debug_print "${0}" "${LINENO}" "TP_DHCP_OR_STATIC_RESULT_CODE: ${TP_DHCP_OR_STATIC_RESULT_CODE}"
    case "${TP_DHCP_OR_STATIC_RESULT_CODE}" in
    
        "${TP_DHCP_OR_STATIC_RESULT_ERROR}")
            MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_ERROR
            MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_MSG=""
            MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_ROLLING=0
            return
            ;;
        
        "${TP_DHCP_OR_STATIC_RESULT_CANCEL}")
            MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_OK
            MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_MSG=""
            MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_ROLLING=-1
            return
            ;;
            
        "${TP_DHCP_OR_STATIC_RESULT_OK}" )
            ;;
        
        *)
            MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_ERROR
            MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_MSG="${MASTER_PAGE_MS_DHCP_OR_STATIC_ERROR_UNKNOWN}"
            MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_ROLLING=0
            return
            ;;
    esac
   
   
	case "${TP_DHCP_OR_STATIC_RESULT_SELECT}" in
	
		# user choose "use static ip"
		"${TP_DHCP_OR_STATIC_RESULT_STATIC}")
			RT_MS_DHCP=0
			
			MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_OK
			MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_ROLLING=1
			MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_MSG=""
			;;
		
		# user choose "use DHCP"
		"${TP_DHCP_OR_STATIC_RESULT_DHCP}")
			RT_MS_DHCP=1
			
			# apply and error handling
			utility_apply_ms_network_conf "${RT_MS_DHCP}" "" "" "" ""
			if [ "${?}" -ne 0 ]; then
				MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_ERROR
				MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_ROLLING=0
				MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_MSG="${UTILITY_APPLY_MS_NETWORK_CONF_RESULT_MSG}"
				return
			fi

            # save to database
            RT_MS_IP="${UTILITY_APPLY_MS_NETWORK_CONF_RESULT_IP}"
            RT_MS_NETMASK="${UTILITY_APPLY_MS_NETWORK_CONF_RESULT_NETMASK}"
            RT_MS_GATEWAY="${UTILITY_APPLY_MS_NETWORK_CONF_RESULT_GATEWAY}"
            RT_MS_DNS="${UTILITY_APPLY_MS_NETWORK_CONF_RESULT_DNS}"
            RT_MS_DNS2="${UTILITY_APPLY_MS_NETWORK_CONF_RESULT_DNS2}"
            utility_save_ms_network_conf \
                "${RT_MS_DHCP}" \
                "${RT_MS_IP}" \
                "${RT_MS_NETMASK}" \
                "${RT_MS_GATEWAY}" \
                "${RT_MS_DNS}" \
                "${RT_MS_DNS2}"
            if [ "${?}" -ne 0 ]; then
				MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_ERROR
				MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_ROLLING=0
				MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_MSG="${MASTER_PAGE_MS_DHCP_OR_STATIC_ERROR_SAVE_CONFIGURATION}: ${UTILITY_SAVE_MS_NETWORK_CONF_RESULT_MSG}"
				return
            fi
            
			MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_OK
			MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_ROLLING=2
			MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_MSG=""
			;;
		
		*)
			MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_ERROR
			MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_MSG="${ERROR_UNKNOWN}"
			MASTER_PAGE_MS_DHCP_OR_STATIC_RESULT_ROLLING=0
			;;
	esac
}